/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.filesystem.s3;

import com.amazon.s3.AWSAuthConnection;
import com.amazon.s3.ListAllMyBucketsResponse;
import com.aptana.core.epl.IMemento;
import com.aptana.ide.core.io.ConnectionPoint;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IBaseRemoteConnectionPoint;
import com.aptana.ide.filesystem.s3.Messages;
import com.aptana.ide.filesystem.s3.Policy;
import com.aptana.ide.filesystem.s3.S3FileStore;
import com.aptana.ide.filesystem.s3.S3FileSystemPlugin;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class S3ConnectionPoint
extends ConnectionPoint
implements IBaseRemoteConnectionPoint {
    public static final String DEFAULT_HOST = "s3.amazonaws.com";
    public static final String TYPE = "s3";
    private static final String ELEMENT_HOST = "host";
    private static final String ELEMENT_PATH = "path";
    private static final String ELEMENT_ACCESS_KEY = "accessKey";
    private IPath path = Path.ROOT;
    private String accessKey = "";
    private char[] password;
    private String host = "s3.amazonaws.com";

    public S3ConnectionPoint() {
        super(TYPE);
    }

    protected void loadState(IMemento memento) {
        super.loadState(memento);
        IMemento child = memento.getChild(ELEMENT_HOST);
        this.host = child != null ? child.getTextData() : DEFAULT_HOST;
        child = memento.getChild(ELEMENT_PATH);
        if (child != null) {
            this.path = child.getTextData() == null ? Path.ROOT : Path.fromPortableString((String)child.getTextData());
        }
        if ((child = memento.getChild(ELEMENT_ACCESS_KEY)) != null) {
            this.accessKey = child.getTextData();
        }
        if (CoreIOPlugin.getAuthenticationManager().hasPersistent(this.getAccessKey())) {
            this.password = CoreIOPlugin.getAuthenticationManager().getPassword(this.getAccessKey());
        }
    }

    protected void saveState(IMemento memento) {
        super.saveState(memento);
        memento.createChild(ELEMENT_HOST).putTextData(this.getHost());
        if (!Path.ROOT.equals((Object)this.path)) {
            memento.createChild(ELEMENT_PATH).putTextData(this.path.toPortableString());
        }
        if (this.getAccessKey().length() != 0) {
            memento.createChild(ELEMENT_ACCESS_KEY).putTextData(this.getAccessKey());
        }
        CoreIOPlugin.getAuthenticationManager().setPassword(this.getAccessKey(), this.password, true);
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
        this.notifyChanged();
    }

    public String getLogin() {
        return this.getAccessKey();
    }

    public void setLogin(String login) {
        this.setAccessKey(login);
    }

    public IPath getPath() {
        return this.path;
    }

    public void setPath(IPath path) {
        this.path = path;
        this.notifyChanged();
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = password;
        String authId = Policy.generateAuthId(TYPE, this);
        CoreIOPlugin.getAuthenticationManager().setPassword(authId, password, false);
        this.notifyChanged();
    }

    public URI getRootURI() {
        try {
            String userInfo = this.getAccessKey();
            return new URI(TYPE, userInfo, this.getHost(), this.getPort(), this.getPath().toString(), null, null);
        }
        catch (URISyntaxException e) {
            S3FileSystemPlugin.log(e);
            return null;
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return -1;
    }

    public void setHost(String host) {
        this.host = host;
        this.notifyChanged();
    }

    public void setPort(int port) {
    }

    public void connect(boolean force, IProgressMonitor monitor) throws CoreException {
        try {
            try {
                AWSAuthConnection connection = ((S3FileStore)this.getRoot()).getAWSConnection();
                ListAllMyBucketsResponse resp = connection.listAllMyBuckets(null);
                if (resp == null || resp.entries == null) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.ide.filesystem.s3", Messages.S3ConnectionPoint_FailToConnect));
                }
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw S3FileSystemPlugin.coreException(e);
            }
        }
        finally {
            super.connect(force, monitor);
        }
    }
}

